<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-money-check-alt"></i> Tedarikci Cek Takibi</h2>
    <a href="<?= BASE_URL ?>/suppliers" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Tedarikciler
    </a>
</div>

<div class="row mb-3">
    <div class="col-md-4">
        <div class="card glass-card bg-gradient-warning text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-hourglass-half"></i> Bekleyen Cek Toplami</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['pending_total'] ?? 0) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card glass-card bg-gradient-success text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-check-circle"></i> Tahsil Edilen</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['collected_total'] ?? 0) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card glass-card bg-gradient-info text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-list"></i> Toplam Cek</h6>
                <h3 class="mb-0"><?= intval($summary['total_count'] ?? 0) ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="card glass-card">
    <div class="card-body">
        <?php if (empty($checks)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i> Henüz cek kaydi bulunmuyor.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Tedarikci</th>
                            <th>Cek No</th>
                            <th>Banka</th>
                            <th>Kesim</th>
                            <th>Vade</th>
                            <th class="text-end">Tutar</th>
                            <th>Durum</th>
                            <th class="text-center">Islem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($checks as $check): ?>
                            <tr>
                                <td>
                                    <a href="<?= BASE_URL ?>/suppliers/view/<?= $check['supplier_id'] ?>">
                                        <?= Helper::escape($check['supplier_name']) ?>
                                    </a>
                                </td>
                                <td><strong><?= Helper::escape($check['check_number']) ?></strong></td>
                                <td><?= Helper::escape($check['bank_name'] ?? '-') ?></td>
                                <td><?= Helper::formatDate($check['issue_date']) ?></td>
                                <td><?= Helper::formatDate($check['due_date']) ?></td>
                                <td class="text-end"><strong><?= Helper::formatMoney($check['amount']) ?></strong></td>
                                <td>
                                    <?php if (($check['status'] ?? '') === 'TAHSIL_EDILDI'): ?>
                                        <span class="badge bg-success">TAHSIL EDILDI</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">BEKLEMEDE</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php if (($check['status'] ?? '') === 'TAHSIL_EDILDI'): ?>
                                        <form method="POST" action="<?= BASE_URL ?>/supplier-checks/mark-pending/<?= $check['id'] ?>" class="d-inline">
                                            <button type="submit" class="btn btn-sm btn-outline-secondary">Beklemede</button>
                                        </form>
                                    <?php else: ?>
                                        <form method="POST" action="<?= BASE_URL ?>/supplier-checks/mark-collected/<?= $check['id'] ?>" class="d-inline">
                                            <button type="submit" class="btn btn-sm btn-success">Tahsil Et</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
