<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-money-check-alt"></i> Alınan Çek Takibi</h2>
    <a href="<?= BASE_URL ?>/received-checks/create" class="btn btn-primary">
        <i class="fas fa-plus"></i> Yeni Çek Ekle
    </a>
</div>

<div class="row mb-3">
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-warning text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-hourglass-half"></i> Bekleyen Çek</h6>
                <h3 class="mb-0">
                    <?= Helper::formatMoney($summary['pending_total'] ?? 0) ?>
                </h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-success text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-check-circle"></i> Tahsil Edilen</h6>
                <h3 class="mb-0">
                    <?= Helper::formatMoney($summary['collected_total'] ?? 0) ?>
                </h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-primary text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-exchange-alt"></i> Ciro Edilen</h6>
                <h3 class="mb-0">
                    <?= Helper::formatMoney($summary['endorsed_total'] ?? 0) ?>
                </h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-info text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-list"></i> Toplam Çek</h6>
                <h3 class="mb-0">
                    <?= intval($summary['total_count'] ?? 0) ?>
                </h3>
            </div>
        </div>
    </div>
</div>

<div class="card glass-card">
    <div class="card-body">
        <?php if (empty($checks)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i> Henüz alınan çek kaydı bulunmuyor.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Müşteri Adı</th>
                            <th>Çek No</th>
                            <th>Banka</th>
                            <th>Vade Tarihi</th>
                            <th class="text-end">Tutar</th>
                            <th>Durum</th>
                            <th class="text-center">İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($checks as $check): ?>
                            <tr>
                                <td><strong>
                                        <?= Helper::escape($check['customer_name']) ?>
                                    </strong></td>
                                <td>
                                    <?= Helper::escape($check['check_number'] ?? '-') ?>
                                </td>
                                <td>
                                    <?= Helper::escape($check['bank_name'] ?? '-') ?>
                                </td>
                                <td>
                                    <?= Helper::formatDate($check['due_date']) ?>
                                </td>
                                <td class="text-end"><strong>
                                        <?= Helper::formatMoney($check['amount']) ?>
                                    </strong></td>
                                <td>
                                    <?php if (($check['status'] ?? '') === 'TAHSIL_EDILDI'): ?>
                                        <span class="badge bg-success">TAHSİL EDİLDİ</span>
                                    <?php elseif (($check['status'] ?? '') === 'CIRO_EDILDI'): ?>
                                        <span class="badge bg-primary">CİRO EDİLDİ</span>
                                    <?php elseif (($check['status'] ?? '') === 'IADE'): ?>
                                        <span class="badge bg-danger">İADE</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">BEKLEMEDE</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <?php if (($check['status'] ?? '') === 'BEKLEMEDE'): ?>
                                            <form method="POST"
                                                action="<?= BASE_URL ?>/received-checks/mark-collected/<?= $check['id'] ?>"
                                                class="d-inline">
                                                <button type="submit" class="btn btn-sm btn-success" title="Tahsil Et">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </form>
                                            <form method="POST"
                                                action="<?= BASE_URL ?>/received-checks/mark-endorsed/<?= $check['id'] ?>"
                                                class="d-inline">
                                                <button type="submit" class="btn btn-sm btn-primary" title="Ciro Et">
                                                    <i class="fas fa-exchange-alt"></i>
                                                </button>
                                            </form>
                                        <?php else: ?>
                                            <form method="POST"
                                                action="<?= BASE_URL ?>/received-checks/mark-pending/<?= $check['id'] ?>"
                                                class="d-inline">
                                                <button type="submit" class="btn btn-sm btn-outline-secondary" title="Beklemede">
                                                    <i class="fas fa-undo"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                        <form method="POST" action="<?= BASE_URL ?>/received-checks/delete/<?= $check['id'] ?>"
                                            class="d-inline"
                                            onsubmit="return confirm('Bu çek kaydını silmek istediğinize emin misiniz?')">
                                            <button type="submit" class="btn btn-sm btn-danger" title="Sil">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>