<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-credit-card"></i> Kredi Kartları</h2>
    <a href="<?= BASE_URL ?>/credit-cards/create" class="btn btn-primary">
        <i class="fas fa-plus"></i> Yeni Kart Ekle
    </a>
</div>

<!-- Özet Bilgiler -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card bg-info text-white mb-3">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-money-bill-wave"></i> Toplam Kart Limiti</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['total_limit']) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-danger text-white mb-3">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-minus-circle"></i> Toplam Borç</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['total_debt']) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white mb-3">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-check-circle"></i> Kullanılabilir Limit</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['available_limit']) ?></h3>
            </div>
        </div>
    </div>
</div>

<?php
$flash = Helper::getFlash();
if ($flash):
    ?>
    <div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
        <?= Helper::escape($flash['message']) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card glass-card">
    <div class="card-body">
        <?php if (empty($cards)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                Henüz kredi kartı kaydı bulunmuyor. <a href="<?= BASE_URL ?>/credit-cards/create">Yeni kart ekleyin</a>.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Banka / Kart Adı</th>
                            <th>Son 4 Hane</th>
                            <th class="text-end">Limit</th>
                            <th class="text-end">Güncel Borç</th>
                            <th class="text-end">Kullanılabilir</th>
                            <th class="text-center">Hesap Kesim / Son Ödeme</th>
                            <th class="text-center">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($cards as $card): ?>
                            <tr>
                                <td>
                                    <strong><?= Helper::escape($card['bank_name']) ?></strong><br>
                                    <small class="text-muted"><?= Helper::escape($card['card_name']) ?></small>
                                </td>
                                <td><?= Helper::escape($card['card_number_last4']) ?></td>
                                <td class="text-end"><?= Helper::formatMoney($card['card_limit']) ?></td>
                                <td class="text-end text-danger font-weight-bold">
                                    <?= Helper::formatMoney($card['current_debt']) ?></td>
                                <td class="text-end text-success"><?= Helper::formatMoney($card['available_limit']) ?></td>
                                <td class="text-center">
                                    <span class="badge bg-secondary" title="Hesap Kesim">HK:
                                        <?= $card['statement_day'] ?></span>
                                    <span class="badge bg-warning text-dark" title="Son Ödeme">SÖ:
                                        <?= $card['payment_due_day'] ?></span>
                                </td>
                                <td class="text-center">
                                    <a href="<?= BASE_URL ?>/credit-cards/add-statement/<?= $card['id'] ?>"
                                        class="btn btn-sm btn-info text-white" title="Dönem Borcu Ekle">
                                        <i class="fas fa-file-invoice-dollar"></i>
                                    </a>
                                    <a href="<?= BASE_URL ?>/credit-cards/edit/<?= $card['id'] ?>"
                                        class="btn btn-sm btn-warning" title="Düzenle">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form method="POST" action="<?= BASE_URL ?>/credit-cards/delete/<?= $card['id'] ?>"
                                        class="d-inline"
                                        onsubmit="return confirm('Bu kartı silmek istediğinize emin misiniz?');">
                                        <button type="submit" class="btn btn-sm btn-danger" title="Sil">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>