<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-money-check-alt"></i> Çek Takibi</h2>
</div>

<!-- Genel Özet Bilgiler -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card bg-success text-white mb-3">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-file-invoice-dollar"></i> Toplam Alınan Çekler</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($alinanSummary['grand_total'] ?? 0) ?></h3>
                <small><?= intval($alinanSummary['total_count'] ?? 0) ?> adet çek</small>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card bg-danger text-white mb-3">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-money-check-alt"></i> Toplam Verilen Çekler</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($verilenSummary['grand_total'] ?? 0) ?></h3>
                <small><?= intval($verilenSummary['total_count'] ?? 0) ?> adet çek</small>
            </div>
        </div>
    </div>
</div>

<!-- Tab Navigation -->
<ul class="nav nav-tabs mb-4" id="cekTabs" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="alinan-tab" data-bs-toggle="tab" data-bs-target="#alinan" type="button"
            role="tab">
            <i class="fas fa-file-invoice-dollar"></i> Alınan Çekler
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="verilen-tab" data-bs-toggle="tab" data-bs-target="#verilen" type="button"
            role="tab">
            <i class="fas fa-money-check-alt"></i> Verilen Çekler
        </button>
    </li>
</ul>

<!-- Tab Content -->
<div class="tab-content" id="cekTabContent">

    <!-- ALINAN ÇEKLER TAB -->
    <div class="tab-pane fade show active" id="alinan" role="tabpanel">
        <div class="row mb-3">
            <div class="col-md-3">
                <div class="card bg-warning text-dark mb-3">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><i class="fas fa-hourglass-half"></i> Bekleyen</h6>
                        <h3 class="mb-0">
                            <?= Helper::formatMoney($alinanSummary['pending_total'] ?? 0) ?>
                        </h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white mb-3">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><i class="fas fa-check-circle"></i> Tahsil Edilen</h6>
                        <h3 class="mb-0">
                            <?= Helper::formatMoney($alinanSummary['collected_total'] ?? 0) ?>
                        </h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-primary text-white mb-3">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><i class="fas fa-exchange-alt"></i> Ciro Edilen</h6>
                        <h3 class="mb-0">
                            <?= Helper::formatMoney($alinanSummary['endorsed_total'] ?? 0) ?>
                        </h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white mb-3">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><i class="fas fa-list"></i> Toplam</h6>
                        <h3 class="mb-0">
                            <?= intval($alinanSummary['total_count'] ?? 0) ?>
                        </h3>
                    </div>
                </div>
            </div>
        </div>

        <div class="card glass-card">
            <div class="card-body">
                <?php if (empty($alinanCekler)): ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> Henüz alınan çek kaydı bulunmuyor.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>Müşteri Adı</th>
                                    <th>Çek No</th>
                                    <th>Banka</th>
                                    <th>Vade Tarihi</th>
                                    <th class="text-end">Tutar</th>
                                    <th>Durum</th>
                                    <th class="text-center">İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($alinanCekler as $check): ?>
                                    <tr>
                                        <td><strong>
                                                <?= Helper::escape($check['customer_name']) ?>
                                            </strong></td>
                                        <td>
                                            <?= Helper::escape($check['check_number'] ?? '-') ?>
                                        </td>
                                        <td>
                                            <?= Helper::escape($check['bank_name'] ?? '-') ?>
                                        </td>
                                        <td>
                                            <?= Helper::formatDate($check['due_date']) ?>
                                        </td>
                                        <td class="text-end"><strong>
                                                <?= Helper::formatMoney($check['amount']) ?>
                                            </strong></td>
                                        <td>
                                            <?php if (($check['status'] ?? '') === 'TAHSIL_EDILDI'): ?>
                                                <span class="badge bg-success">TAHSİL EDİLDİ</span>
                                            <?php elseif (($check['status'] ?? '') === 'CIRO_EDILDI'): ?>
                                                <span class="badge bg-primary">CİRO EDİLDİ</span>
                                            <?php elseif (($check['status'] ?? '') === 'IADE'): ?>
                                                <span class="badge bg-danger">İADE</span>
                                            <?php else: ?>
                                                <span class="badge bg-warning text-dark">BEKLEMEDE</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group btn-group-sm" role="group">
                                                <?php if (($check['status'] ?? '') === 'BEKLEMEDE'): ?>
                                                    <form method="POST"
                                                        action="<?= BASE_URL ?>/checks/mark-alinan-collected/<?= $check['id'] ?>"
                                                        class="d-inline">
                                                        <button type="submit" class="btn btn-success" title="Tahsil Et">
                                                            <i class="fas fa-check"></i>
                                                        </button>
                                                    </form>
                                                    <form method="POST"
                                                        action="<?= BASE_URL ?>/checks/mark-alinan-endorsed/<?= $check['id'] ?>"
                                                        class="d-inline">
                                                        <button type="submit" class="btn btn-primary" title="Ciro Et">
                                                            <i class="fas fa-exchange-alt"></i>
                                                        </button>
                                                    </form>
                                                <?php else: ?>
                                                    <form method="POST"
                                                        action="<?= BASE_URL ?>/checks/mark-alinan-pending/<?= $check['id'] ?>"
                                                        class="d-inline">
                                                        <button type="submit" class="btn btn-outline-secondary" title="Beklemede">
                                                            <i class="fas fa-undo"></i>
                                                        </button>
                                                    </form>
                                                <?php endif; ?>
                                                <form method="POST"
                                                    action="<?= BASE_URL ?>/checks/delete-alinan/<?= $check['id'] ?>"
                                                    class="d-inline"
                                                    onsubmit="return confirm('Bu çek kaydını silmek istediğinize emin misiniz?')">
                                                    <button type="submit" class="btn btn-danger" title="Sil">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- VERILEN ÇEKLER TAB -->
    <div class="tab-pane fade" id="verilen" role="tabpanel">
        <div class="row mb-3">
            <div class="col-md-4">
                <div class="card bg-warning text-dark mb-3">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><i class="fas fa-hourglass-half"></i> Bekleyen Çek Toplamı</h6>
                        <h3 class="mb-0">
                            <?= Helper::formatMoney($verilenSummary['pending_total'] ?? 0) ?>
                        </h3>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-success text-white mb-3">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><i class="fas fa-check-circle"></i> Tahsil Edilen</h6>
                        <h3 class="mb-0">
                            <?= Helper::formatMoney($verilenSummary['collected_total'] ?? 0) ?>
                        </h3>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-info text-white mb-3">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><i class="fas fa-list"></i> Toplam Çek</h6>
                        <h3 class="mb-0">
                            <?= intval($verilenSummary['total_count'] ?? 0) ?>
                        </h3>
                    </div>
                </div>
            </div>
        </div>

        <div class="card glass-card">
            <div class="card-body">
                <?php if (empty($verilenCekler)): ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> Henüz verilen çek kaydı bulunmuyor.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>Tedarikçi</th>
                                    <th>Çek No</th>
                                    <th>Banka</th>
                                    <th>Kesim</th>
                                    <th>Vade</th>
                                    <th class="text-end">Tutar</th>
                                    <th>Durum</th>
                                    <th class="text-center">İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($verilenCekler as $check): ?>
                                    <tr>
                                        <td>
                                            <a href="<?= BASE_URL ?>/suppliers/view/<?= $check['supplier_id'] ?>">
                                                <?= Helper::escape($check['supplier_name']) ?>
                                            </a>
                                        </td>
                                        <td><strong>
                                                <?= Helper::escape($check['check_number']) ?>
                                            </strong></td>
                                        <td>
                                            <?= Helper::escape($check['bank_name'] ?? '-') ?>
                                        </td>
                                        <td>
                                            <?= Helper::formatDate($check['issue_date']) ?>
                                        </td>
                                        <td>
                                            <?= Helper::formatDate($check['due_date']) ?>
                                        </td>
                                        <td class="text-end"><strong>
                                                <?= Helper::formatMoney($check['amount']) ?>
                                            </strong></td>
                                        <td>
                                            <?php if (($check['status'] ?? '') === 'TAHSIL_EDILDI'): ?>
                                                <span class="badge bg-success">TAHSİL EDİLDİ</span>
                                            <?php else: ?>
                                                <span class="badge bg-warning text-dark">BEKLEMEDE</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center">
                                            <?php if (($check['status'] ?? '') === 'TAHSIL_EDILDI'): ?>
                                                <form method="POST"
                                                    action="<?= BASE_URL ?>/checks/mark-verilen-pending/<?= $check['id'] ?>"
                                                    class="d-inline">
                                                    <button type="submit"
                                                        class="btn btn-sm btn-outline-secondary">Beklemede</button>
                                                </form>
                                            <?php else: ?>
                                                <form method="POST"
                                                    action="<?= BASE_URL ?>/checks/mark-verilen-collected/<?= $check['id'] ?>"
                                                    class="d-inline">
                                                    <button type="submit" class="btn btn-sm btn-success">Tahsil Et</button>
                                                </form>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>