<?php include __DIR__ . '/../../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-file-invoice-dollar"></i> BCH (Banka Cari Hesabı) Takibi</h2>
    <div class="btn-group">
        <a href="<?= BASE_URL ?>/banks/bch/create" class="btn btn-primary">
            <i class="fas fa-plus"></i> Yeni BCH Ekle
        </a>
        <a href="<?= BASE_URL ?>/banks" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Geri
        </a>
    </div>
</div>

<?php
$flash = Helper::getFlash();
if ($flash):
?>
<div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
    <?= Helper::escape($flash['message']) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Özet Kartlar -->
<div class="row mb-3">
    <div class="col-md-4">
        <div class="card glass-card bg-gradient-warning text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-hourglass-half"></i> Bekleyen BCH</h6>
                <h3 class="mb-0" data-count="<?= $summary['pending_total'] ?? 0 ?>">
                    <?= Helper::formatMoney($summary['pending_total'] ?? 0) ?>
                </h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card glass-card bg-gradient-success text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-check-circle"></i> Ödenen BCH</h6>
                <h3 class="mb-0" data-count="<?= $summary['paid_total'] ?? 0 ?>">
                    <?= Helper::formatMoney($summary['paid_total'] ?? 0) ?>
                </h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card glass-card bg-gradient-info text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-list"></i> Toplam Kayıt</h6>
                <h3 class="mb-0"><?= $summary['total_count'] ?? 0 ?></h3>
            </div>
        </div>
    </div>
</div>

<!-- Filtre ve Arama -->
<div class="card glass-card mb-3">
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-4">
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                    <input type="text" class="form-control" id="searchInput" placeholder="Banka ara...">
                </div>
            </div>
            <div class="col-md-3">
                <select class="form-select" id="sortSelect">
                    <option value="date-asc">Vade Tarihi (Yakın → Uzak)</option>
                    <option value="date-desc">Vade Tarihi (Uzak → Yakın)</option>
                    <option value="amount-desc">Tutar (Yüksek → Düşük)</option>
                    <option value="amount-asc">Tutar (Düşük → Yüksek)</option>
                </select>
            </div>
            <div class="col-md-3">
                <select class="form-select" id="statusFilter">
                    <option value="all">Tüm Durumlar</option>
                    <option value="BEKLEMEDE">Sadece Bekleyen</option>
                    <option value="ÖDEME">Sadece Ödenen</option>
                </select>
            </div>
            <div class="col-md-2">
                <button class="btn btn-secondary w-100" id="resetBtn">
                    <i class="fas fa-redo"></i> Sıfırla
                </button>
            </div>
        </div>
    </div>
</div>

<!-- BCH Listesi -->
<div class="card glass-card">
    <div class="card-body">
        <?php if (empty($bchPayments)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                Henüz BCH kaydı bulunmuyor. <a href="<?= BASE_URL ?>/banks/bch/create">Yeni BCH ekleyin</a>.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th><i class="fas fa-university"></i> Banka</th>
                            <th class="text-end"><i class="fas fa-lira-sign"></i> Tutar</th>
                            <th><i class="fas fa-calendar"></i> Vade Tarihi</th>
                            <th class="text-center"><i class="fas fa-info-circle"></i> Durum</th>
                            <th><i class="fas fa-file-alt"></i> Referans</th>
                            <th class="text-center"><i class="fas fa-cog"></i> İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($bchPayments as $bch): ?>
                        <tr class="bch-row"
                            data-bank="<?= strtolower(Helper::escape($bch['bank_name'])) ?>"
                            data-amount="<?= $bch['amount'] ?>"
                            data-date="<?= $bch['due_date'] ?>"
                            data-status="<?= $bch['status'] ?>">
                            <td>
                                <strong><?= Helper::escape($bch['bank_name']) ?></strong>
                            </td>
                            <td class="text-end">
                                <strong class="text-danger">
                                    <?= Helper::formatMoney($bch['amount']) ?>
                                </strong>
                            </td>
                            <td>
                                <?= Helper::formatDate($bch['due_date']) ?>
                            </td>
                            <td class="text-center">
                                <?php if ($bch['status'] === 'BEKLEMEDE'): ?>
                                    <span class="badge bg-warning">
                                        <i class="fas fa-hourglass-half"></i> BEKLEMEDE
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-success">
                                        <i class="fas fa-check"></i> ÖDEME
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td><?= Helper::escape($bch['reference_number'] ?? '-') ?></td>
                            <td class="text-center">
                                <div class="btn-group btn-group-sm">
                                    <?php if ($bch['status'] === 'BEKLEMEDE'): ?>
                                        <form method="POST" action="<?= BASE_URL ?>/banks/bch/mark-paid/<?= $bch['id'] ?>" style="display:inline;">
                                            <button type="submit" class="btn btn-success" title="Ödendi Olarak İşaretle" onclick="return confirm('Bu BCH\'yi ödendi olarak işaretlemek istediğinize emin misiniz?')">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                    <a href="<?= BASE_URL ?>/banks/bch/edit/<?= $bch['id'] ?>" class="btn btn-warning" title="Düzenle">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-danger"
                                            data-bs-toggle="modal"
                                            data-bs-target="#deleteModal<?= $bch['id'] ?>"
                                            title="Sil">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>

                        <!-- Delete Modal -->
                        <div class="modal fade" id="deleteModal<?= $bch['id'] ?>" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">
                                            <i class="fas fa-exclamation-triangle text-warning"></i> BCH Sil
                                        </h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Bu BCH kaydını silmek istediğinizden emin misiniz?</p>
                                        <div class="alert alert-warning">
                                            <strong>Banka:</strong> <?= Helper::escape($bch['bank_name']) ?><br>
                                            <strong>Tutar:</strong> <?= Helper::formatMoney($bch['amount']) ?><br>
                                            <strong>Vade:</strong> <?= Helper::formatDate($bch['due_date']) ?>
                                        </div>
                                        <p class="text-danger mb-0"><small><i class="fas fa-info-circle"></i> Bu işlem geri alınamaz!</small></p>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                                        <form method="POST" action="<?= BASE_URL ?>/banks/bch/delete/<?= $bch['id'] ?>" class="d-inline">
                                            <button type="submit" class="btn btn-danger">
                                                <i class="fas fa-trash"></i> Sil
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const sortSelect = document.getElementById('sortSelect');
    const statusFilter = document.getElementById('statusFilter');
    const resetBtn = document.getElementById('resetBtn');
    const rows = Array.from(document.querySelectorAll('.bch-row'));

    function applyFilters() {
        const searchTerm = searchInput.value.toLowerCase();
        const sortValue = sortSelect.value;
        const filterValue = statusFilter.value;

        // Filtreleme
        let visibleRows = rows.filter(row => {
            const bank = row.dataset.bank;
            const status = row.dataset.status;

            if (searchTerm && !bank.includes(searchTerm)) return false;
            if (filterValue !== 'all' && status !== filterValue) return false;

            return true;
        });

        // Sıralama
        visibleRows.sort((a, b) => {
            const aAmount = parseFloat(a.dataset.amount);
            const bAmount = parseFloat(b.dataset.amount);
            const aDate = new Date(a.dataset.date);
            const bDate = new Date(b.dataset.date);

            switch(sortValue) {
                case 'date-asc': return aDate - bDate;
                case 'date-desc': return bDate - aDate;
                case 'amount-desc': return bAmount - aAmount;
                case 'amount-asc': return aAmount - bAmount;
                default: return 0;
            }
        });

        // DOM güncelle
        const tbody = rows[0]?.parentElement;
        if (tbody) {
            rows.forEach(row => row.style.display = 'none');
            visibleRows.forEach(row => {
                row.style.display = '';
                tbody.appendChild(row);
            });
        }
    }

    // Event listeners
    searchInput.addEventListener('input', applyFilters);
    sortSelect.addEventListener('change', applyFilters);
    statusFilter.addEventListener('change', applyFilters);
    resetBtn.addEventListener('click', () => {
        searchInput.value = '';
        sortSelect.value = 'date-asc';
        statusFilter.value = 'all';
        applyFilters();
    });

    // İlk yükleme
    applyFilters();
});
</script>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
