<?php include __DIR__ . '/../../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus"></i> Yeni BCH Ekle</h2>
    <a href="<?= BASE_URL ?>/banks/bch" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Geri
    </a>
</div>

<?php
$flash = Helper::getFlash();
if ($flash):
?>
<div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
    <?= Helper::escape($flash['message']) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="card glass-card">
    <div class="card-body">
        <form method="POST" action="<?= BASE_URL ?>/banks/bch/store">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="bank_name" class="form-label">Banka Adı <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="bank_name" name="bank_name" required>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="amount" class="form-label">Tutar (₺) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" class="form-control" id="amount" name="amount" required min="0.01">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="due_date" class="form-label">Vade Tarihi <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="due_date" name="due_date" required>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="reference_number" class="form-label">Referans/Dekont No</label>
                        <input type="text" class="form-control" id="reference_number" name="reference_number">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="status" class="form-label">Durum</label>
                        <select class="form-select" id="status" name="status">
                            <option value="BEKLEMEDE" selected>BEKLEMEDE</option>
                            <option value="ÖDEME">ÖDEME</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="payment_date" class="form-label">Ödeme Tarihi</label>
                        <input type="date" class="form-control" id="payment_date" name="payment_date">
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">Açıklama</label>
                <textarea class="form-control" id="description" name="description" rows="3"></textarea>
            </div>

            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                <a href="<?= BASE_URL ?>/banks/bch" class="btn btn-secondary">
                    <i class="fas fa-times"></i> İptal
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Kaydet
                </button>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
