<?php
/**
 * Şifre Güncelleme
 */

require_once __DIR__ . '/../includes/autoload.php';

echo "<h1>Şifre Güncelleme</h1>";

$db = Database::getInstance();

// Yeni şifre hash'i oluştur
$newPassword = 'admin123';
$passwordHash = password_hash($newPassword, PASSWORD_BCRYPT);

echo "<p>Yeni şifre: <strong>$newPassword</strong></p>";
echo "<p>Hash: <code>$passwordHash</code></p>";

// Veritabanını güncelle
try {
    $result = $db->update('users', ['password_hash' => $passwordHash], 'username = ?', ['admin']);

    echo "<div style='background: #d4edda; padding: 20px; border: 1px solid #c3e6cb; border-radius: 5px; margin: 20px 0;'>";
    echo "<h2 style='color: #155724; margin: 0;'>✓ Başarılı!</h2>";
    echo "<p style='color: #155724; margin: 10px 0 0 0;'>Şifre güncellendi. Şimdi giriş yapabilirsiniz.</p>";
    echo "</div>";

    echo "<p><strong>Giriş Bilgileri:</strong></p>";
    echo "<ul>";
    echo "<li>Kullanıcı Adı: <strong>admin</strong></li>";
    echo "<li>Şifre: <strong>admin123</strong></li>";
    echo "</ul>";

    echo "<p><a href='login' style='background: #667eea; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block; margin-top: 20px;'>Login Sayfasına Git</a></p>";

    // Doğrulama yap
    echo "<hr>";
    echo "<h2>Doğrulama</h2>";

    $user = $db->selectOne("SELECT * FROM users WHERE username = ?", ['admin']);

    if ($user) {
        echo "<p>Kullanıcı bulundu: " . $user['username'] . "</p>";
        echo "<p>Hash veritabanında: " . substr($user['password_hash'], 0, 60) . "</p>";

        // Şifre doğrulama testi
        if (password_verify('admin123', $user['password_hash'])) {
            echo "<div style='background: #d4edda; padding: 10px; color: #155724; border-radius: 5px;'>";
            echo "✓ Şifre doğrulama başarılı! 'admin123' şifresi çalışıyor.";
            echo "</div>";
        } else {
            echo "<div style='background: #f8d7da; padding: 10px; color: #721c24; border-radius: 5px;'>";
            echo "✗ Şifre doğrulama başarısız!";
            echo "</div>";
        }
    }

} catch (Exception $e) {
    echo "<div style='background: #f8d7da; padding: 20px; border: 1px solid #f5c6cb; border-radius: 5px;'>";
    echo "<h2 style='color: #721c24; margin: 0;'>✗ Hata!</h2>";
    echo "<p style='color: #721c24;'>" . $e->getMessage() . "</p>";
    echo "</div>";
}
