<?php
/**
 * DashboardController - Ana sayfa
 */

class DashboardController
{
    private $db;
    private $auth;

    public function __construct()
    {
        $this->db = Database::getInstance();
        $this->auth = new Auth();
    }

    public function index()
    {
        // Dashboard özet bilgilerini çek
        $summary = $this->db->selectOne("SELECT * FROM v_dashboard_summary");

        // Yaklaşan ödemeler (7 gün)
        $upcomingPayments = $this->db->select("
            SELECT * FROM v_all_payments
            WHERE payment_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 7 DAY)
            AND status != 'paid'
            ORDER BY payment_date ASC
            LIMIT 10
        ");

        // Banka toplam limiti ve kullanımı
        $bankSummary = $this->db->selectOne("
            SELECT
                SUM(limit_amount) as total_limit,
                SUM(used_amount) as total_used,
                SUM(available_amount) as total_available
            FROM banks
        ");

        // Tedarikçi özeti
        $supplierSummary = $this->db->selectOne("
            SELECT
                COUNT(DISTINCT s.id) as total_suppliers,
                COALESCE(SUM(
                    CASE
                        WHEN st.transaction_type IN ('purchase', 'adjustment') THEN st.amount
                        WHEN st.transaction_type IN ('payment', 'refund') THEN -st.amount
                        ELSE 0
                    END
                ), 0) as total_debt
            FROM suppliers s
            LEFT JOIN supplier_transactions st ON s.id = st.supplier_id
        ");

        // Çek özeti
        $checkSummary = $this->db->selectOne("
            SELECT
                (SELECT COUNT(*) FROM received_checks WHERE status = 'BEKLEMEDE') as alinan_bekleyen,
                (SELECT SUM(amount) FROM received_checks WHERE status = 'BEKLEMEDE') as alinan_bekleyen_tutar,
                (SELECT COUNT(*) FROM supplier_checks WHERE status = 'BEKLEMEDE') as verilen_bekleyen,
                (SELECT SUM(amount) FROM supplier_checks WHERE status = 'BEKLEMEDE') as verilen_bekleyen_tutar
        ");

        // View'a veri gönder
        $auth = $this->auth; // View için auth nesnesini hazırla
        require_once __DIR__ . '/../views/dashboard/index.php';
    }
}
