<?php
/**
 * ApiController - API Endpoints
 */

class ApiController {
    private $db;
    private $auth;

    public function __construct() {
        $this->db = Database::getInstance();
        $this->auth = new Auth();
    }

    public function handle($action, $id) {
        header('Content-Type: application/json');

        switch ($action) {
            case 'calendar-events':
                $this->calendarEvents();
                break;
            default:
                echo json_encode(['error' => 'Invalid endpoint']);
        }
    }

    private function calendarEvents() {
        // v_all_payments view'ından tüm ödemeleri çek
        $payments = $this->db->select("
            SELECT
                source,
                source_id,
                payment_date,
                payment_name,
                amount,
                status,
                category
            FROM v_all_payments
            WHERE payment_date IS NOT NULL
            ORDER BY payment_date ASC
        ");

        $events = [];

        foreach ($payments as $payment) {
            // Durum renklerini ayarla
            $color = match($payment['status']) {
                'paid' => '#28a745',      // Yeşil - Ödendi
                'pending' => '#ffc107',   // Sarı - Beklemede
                'overdue' => '#dc3545',   // Kırmızı - Gecikmiş
                default => '#6c757d'      // Gri - Diğer
            };

            $events[] = [
                'title' => $payment['payment_name'],
                'start' => $payment['payment_date'],
                'color' => $color,
                'extendedProps' => [
                    'amount' => Helper::formatMoney($payment['amount']),
                    'status' => Helper::translateStatus($payment['status']),
                    'category' => $payment['category'],
                    'source' => $payment['source']
                ]
            ];
        }

        echo json_encode($events);
        exit;
    }
}
