# KESKA Mali Takip Sistemi

Excel tabanlı mali takip sistemini profesyonel web uygulamasına dönüştürülen proje.

## Kurulum Adımları

### 1. Gereksinimler
- XAMPP veya WAMP (PHP 8.0+, MySQL 5.7+)
- Web tarayıcı

### 2. Proje Kurulumu

1. **Projeyi XAMPP'a kopyalayın**
   ```
   C:\xampp\htdocs\KRMuhasebe
   ```

2. **Veritabanını oluşturun**
   - XAMPP Control Panel'den MySQL'i başlatın
   - Tarayıcıda `http://localhost/phpmyadmin` açın
   - Sol tarafta "Yeni" butonuna tıklayın
   - Veritabanı adı: `keska_db`
   - Karakter seti: `utf8mb4_turkish_ci`
   - "Oluştur" butonuna tıklayın

3. **SQL şemasını import edin**
   - `keska_db` veritabanını seçin
   - Üstte "SQL" sekmesine tıklayın
   - `sql/schema.sql` dosyasının içeriğini kopyalayın
   - SQL kutusuna yapıştırın
   - "Git" butonuna tıklayın

4. **Veritabanı ayarlarını kontrol edin**
   - `config/database.php` dosyasını açın
   - Development ayarlarını kontrol edin:
     ```php
     DB_HOST: localhost
     DB_NAME: keska_db
     DB_USER: root
     DB_PASS: (boş)
     ```

### 3. Uygulamayı Başlatın

1. XAMPP'ta Apache ve MySQL'i çalıştırın
2. Tarayıcıda açın: `http://localhost/KRMuhasebe`
3. Giriş bilgileri:
   - **Kullanıcı adı:** admin
   - **Şifre:** admin123

## Özellikler

### ✅ Tamamlanan (Faz 1)
- ✅ MVC yapısı ve routing sistemi
- ✅ Veritabanı şeması (12 tablo + 2 view)
- ✅ Kimlik doğrulama sistemi
- ✅ Dashboard (özet kartlar ve tablolar)
- ✅ Responsive layout
- ✅ Güvenlik (PDO, CSRF, XSS koruması)

### 🚧 Devam Eden
- Tedarikçi modülü (CRUD işlemleri)
- Banka modülü
- Kredi kartı modülü
- Aylık ödemeler
- Excel import/export
- Grafik ve raporlar
- Bildirim sistemi

## Proje Yapısı

```
KRMuhasebe/
├── config/          # Yapılandırma dosyaları
├── core/            # Database, Auth, Helper sınıfları
├── models/          # Veri modelleri
├── controllers/     # Controller'lar
├── views/           # View dosyaları
├── public/          # Web root (CSS, JS, resimler)
├── sql/             # Veritabanı şemaları
└── includes/        # Autoload ve yardımcı dosyalar
```

## Veritabanı Tabloları

1. **users** - Kullanıcı yönetimi
2. **suppliers** - Tedarikçi borçları ve çek takibi
3. **banks** - Banka hesapları ve KMH limitleri
4. **bank_transactions** - Banka işlem geçmişi
5. **credit_cards** - Kredi kartı bilgileri
6. **credit_card_payments** - Aylık kart ödemeleri
7. **monthly_payments** - Tekrarlayan ödemeler
8. **monthly_payment_details** - Aylık ödeme detayları
9. **all_payments_consolidated** - Konsolide ödemeler
10. **notifications** - Bildirimler
11. **import_history** - Excel import kayıtları
12. **activity_logs** - Sistem aktivite logları

## Sonraki Adımlar

### Faz 2: Modül Geliştirme
1. Tedarikçi CRUD işlemleri
2. Banka yönetimi
3. Kredi kartı takibi
4. Aylık ödeme planlaması

### Faz 3: Excel Entegrasyonu
1. Excel import sistemi
2. Mevcut Excel dosyasından veri aktarımı
3. Excel export özellikleri

### Faz 4: Gelişmiş Özellikler
1. Gerçek zamanlı grafikler (Chart.js)
2. Otomatik bildirim sistemi
3. Takvim görünümü
4. PDF raporlar

## Güvenlik Notları

### ⚠️ Üretim Ortamına Geçmeden Önce

1. **Admin şifresini değiştirin!**
   ```sql
   UPDATE users SET password_hash = '$2y$10$YourNewHashHere' WHERE username = 'admin';
   ```

2. **config/database.php** dosyasında production ayarlarını yapın

3. **HTTPS** kullanın

4. **.htaccess** güvenlik başlıklarını aktif edin

## Teknik Detaylar

- **Backend:** PHP 8.0+ (Sade PHP MVC)
- **Database:** MySQL/MariaDB
- **Frontend:** Bootstrap 5, jQuery
- **Grafikler:** Chart.js
- **Tablolar:** DataTables
- **Icons:** Font Awesome 6

## Destek

Sorularınız için:
- GitHub Issues: [Proje sayfası]
- Email: [İletişim]

## Lisans

Bu proje [Lisans Adı] altında lisanslanmıştır.

---

**Geliştirici Notu:** Bu projenin temel altyapısı (Faz 1) tamamlanmıştır. Modül geliştirmeleri için `plan.md` dosyasına bakınız.
