# CPanel Kurulum ve Taşıma Rehberi

Bu rehber, KESKA Mali Takip Sistemi yazılımını yerel bilgisayarınızdan (localhost) cPanel hostinginize (`finans.keska.org`) nasıl taşıyacağınızı adım adım anlatır.

## Hazırlık (Otomatik Yapıldı)

Sizin için aşağıdaki işlemleri otomatik olarak yaptım:
1.  Veritabanı yedeğini aldım: `keska_db_backup.sql` (Ana dizinde)
2.  Sunucu için örnek ayar dosyasıuşturdum: `config/production_config.php`
3.  Ana ayar dosyasını (`config/config.php`) sunucuyu otomatik tanıyacak şekilde güncelledim.

---

## Adım Adım Taşıma İşlemi

### 1. Dosyaları Hazırlama
1.  `KRMuhasebe` klasöründeki tüm dosyaları seçin ve bir **ZIP** dosyası yapın.
    *   **Önemli:** Klasörün kendisini değil, *içindeki* dosyaları seçip zipleyin. Yani ziplenen dosyayı açınca direkt `index.php`, `config`, `public` vb. görünmeli.

### 2. cPanel'e Dosya Yükleme
1.  cPanel'e giriş yapın ve **Dosya Yöneticisi**ne (File Manager) gidin.
2.  `finans.keska.org` için oluşturulan kök dizine (genelde `public_html/finans.keska.org` veya sadece `finans.keska.org`) girin.
3.  Oluşturduğunuz **ZIP** dosyasını buraya **Yükle** (Upload).
4.  Yükleme bitince ZIP dosyasına sağ tıklayıp **Extract** (Çıkar) diyerek dosyaları klasöre açın.

### 3. Veritabanı Oluşturma
1.  cPanel ana sayfasına dönün ve **MySQL Veritabanı Sihirbazı**na (MySQL Database Wizard) tıklayın.
2.  **Adım 1:** Yeni bir veritabanı adı girin (Örn: `keska_finans`).
3.  **Adım 2:** Bir veritabanı kullanıcısı ve **güçlü bir şifre** oluşturun (Bu şifreyi bir yere not edin!).
4.  **Adım 3:** Kullanıcıya "Tüm Ayrıcalıkları" (All Privileges) verin ve işlemi tamamlayın.

### 4. Veritabanını İçe Aktarma
1.  cPanel ana sayfasına dönün ve **phpMyAdmin**'e girin.
2.  Sol taraftan az önce oluşturduğunuz veritabanını seçin.
3.  Üst menüden **İçe Aktar** (Import) sekmesine tıklayın.
4.  "Dosya Seç" butonuna tıklayın ve bilgisayarınızdaki `c:\xampp\htdocs\KRMuhasebe\keska_db_backup.sql` dosyasını seçin.
5.  En alttaki **Git** (Go) butonuna basarak yüklemeyi tamamlayın.

### 5. Ayarları Yapılandırma
1.  cPanel Dosya Yöneticisi'ne geri dönün.
2.  `config` klasörüne girin.
3.  `production_config.php` dosyasının adını `database.php` olarak değiştirin (Eski `database.php`'yi silebilir veya adını değiştirebilirsiniz).
4.  Yeni `database.php` dosyasına sağ tıklayıp **Edit** (Düzenle) deyin.
5.  Aşağıdaki alanları 3. adımda oluşturduğunuz bilgilerle güncelleyin:
    ```php
    define('DB_NAME', 'keska_db_name'); // cPanel veritabanı adı (örn: kullanıcıadı_finans)
    define('DB_USER', 'keska_db_user'); // cPanel kullanıcı adı (örn: kullanıcıadı_admin)
    define('DB_PASSWORD', 'strong_password'); // Belirlediğiniz şifre
    ```
6.  Dosyayı kaydedin.

### 6. Public Klasörü Ayarı (Önemli!)
Projenin güvenlik yapısı gereği sitenizin ana dizini `public` klasörü olmalıdır. Bunu sağlamak için iki yöntem var:

**Yöntem A: Subdomain Yönlendirmesi (Önerilen)**
1.  cPanel'de "Subdomains" (Alt Etki Alanları) menüsüne gidin.
2.  `finans.keska.org` subdomainini bulun.
3.  "Document Root" (Belge Kökü) kısmını `.../finans.keska.org/public` olarak değiştirin (Sonuna `/public` ekleyin).

**Yöntem B: .htaccess ile Yönlendirme (Alternatif)**
Eğer Yöntem A'yı yapamazsanız, proje ana dizininde (public klasörünün yanında) bir `.htaccess` dosyası oluşturun ve içine şunu yazın:
```apache
RewriteEngine On
RewriteRule ^(.*)$ public/$1 [L]
```

### 7. Kontrol
Artık `https://finans.keska.org` adresine giderek sitenizi görüntüleyebilmelisiniz.
- Giriş bilgileriniz yerel bilgisayarınızdaki ile aynıdır (admin / admin123).
- İlk girişte şifrenizi değiştirmeyi unutmayın!
