# Çek İşleme Sistemi - Kurulum Kılavuzu

## Veritabanı Kurulumu

### Adım 1: SQL Dosyasını Çalıştır

Veritabanınızda `customer_checks.sql` dosyasını çalıştırarak gerekli tabloları oluşturun:

```bash
mysql -u root -p keska_db < sql/customer_checks.sql
```

Veya phpMyAdmin kullanarak:
1. phpMyAdmin'e giriş yapın
2. `keska_db` veritabanını seçin
3. SQL sekmesine tıklayın
4. `sql/customer_checks.sql` dosyasının içeriğini yapıştırın
5. "Çalıştır" butonuna basın

### Adım 2: Çek Import Sayfasını Kullan

1. Tarayıcınızda aşağıdaki URL'yi açın:
   ```
   http://localhost/KRMuhasebe/cek-import.html
   ```

2. Sayfada göreceğiniz tablolar:
   - **Verilen Çekler**: 9 adet (toplam 714,500.00 TL)
   - **Alınan Çekler**: 5 adet (toplam 1,150,000.00 TL)

3. "Verileri İçe Aktar" butonuna tıklayın

4. Sistem:
   - Eksik tedarikcileri otomatik oluşturacak
   - Tüm çekleri veritabanına kaydedecek
   - Başarı mesajı gösterecek

### Adım 3: Çekleri Görüntüle

Sisteme giriş yapın ve:

- **Verilen Çekleri** görüntülemek için:
  Sidebar → **Verilen Çekler** menüsüne tıklayın

- **Alınan Çekleri** görüntülemek için:
  Sidebar → **Alınan Çekler** menüsüne tıklayın

## Import Edilen Veriler

### Verilen Çekler (Tedarikcilere)

| Tedarikçi | Banka | Tutar | Vade |
|-----------|-------|-------|------|
| CENSAN SONDAJ | AKBANK | 19,500.00 | 27/02/2026 |
| YEŞİLER PNÖMATİK | HALK B | 190,000.00 | 06/03/2026 |
| ARTER MÜH - LABORATUVAR | İŞ BANK | 45,000.00 | 18/03/2026 |
| KAV OTO Hidrolik Yağ | ZİRAAT B | 45,000.00 | 20/03/2026 |
| ARTER MÜH - LABORATUVAR | İŞ BANK | 45,000.00 | 21/04/2026 |
| KAV OTO Hidrolik Yağ | ZİRAAT B | 45,000.00 | 24/04/2026 |
| Furkan Sondaj Ekipmanları | İŞ BANK | 75,000.00 | 24/04/2026 |
| Furkan Sondaj Ekipmanları | İŞ BANK | 100,000.00 | 29/05/2026 |
| Furkan Sondaj Ekipmanları | İŞ BANK | 150,000.00 | 25/06/2026 |

**Toplam**: 714,500.00 TL

### Alınan Çekler (Müşterilerden)

| Müşteri | Banka | Tutar | Vade |
|---------|-------|-------|------|
| MUHAMMET BAHÇE | ZİRAAT B | 100,000.00 | 16/02/2026 |
| ALİ MİMARLIK MEHMET MERİÇ | DENİZBANK | 200,000.00 | 13/03/2026 |
| MURAT YILDIZ | QNB | 280,000.00 | 22/05/2026 |
| MURAT YILDIZ | QNB | 280,000.00 | 19/06/2026 |
| MURAT YILDIZ | QNB | 290,000.00 | 24/07/2026 |

**Toplam**: 1,150,000.00 TL

## Sorun Giderme

### Hata: "Table 'received_checks' doesn't exist"

**Çözüm**: `customer_checks.sql` dosyasını çalıştırın.

### Hata: "Supplier_checks unique constraint violation"

**Çözüm**: Bu normal davranış. Sistem aynı işlemi tekrar eklemeye çalışıyor. Her tedarikçi işlemi için tek bir çek kaydı olabilir.

### Tedarikçi Otomatik Oluşturulmuyor

**Kontrol Et**: CheckImportController.php dosyasının doğru yüklendiğinden emin olun.

## Özellikler

✅ Otomatik tedarikçi oluşturma  
✅ Çek durum takibi (Beklemede, Tahsil Edildi, Ciro Edildi, İade)  
✅ Toplu import  
✅ Manuel çek ekleme  
✅ Çek silme  
✅ Durum güncelleme  

## Güvenlik

> **UYARI**: `cek-import.html` dosyası hassas verileri içerir. Production ortamında bu dosyayı kaldırın veya şifre koruması ekleyin.
